/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.events;

import net.creeperhost.chickens.client.ChickenBakedItemModel;
import net.creeperhost.chickens.client.render.RenderChickensChicken;
import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.creeperhost.chickens.init.ModEntities;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="chickens", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRegister(RegistryEvent.Register<Block> event) {
        ModEntities.init();
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        for (RegistryObject entry : ModEntities.ENTITIES.getEntries()) {
            event.put((EntityType)entry.get(), EntityChickensChicken.prepareAttributes().m_22265_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerRender(EntityRenderersEvent.RegisterRenderers event) {
        for (RegistryObject entry : ModEntities.ENTITIES.getEntries()) {
            EntityType entityType = (EntityType)entry.get();
            event.registerEntityRenderer(entityType, RenderChickensChicken::new);
        }
        event.registerEntityRenderer((EntityType)ModEntities.EGG.get(), ThrownItemRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        ModelResourceLocation location = new ModelResourceLocation("chickens", "chicken_item", "inventory");
        BakedModel model = (BakedModel)e.getModelRegistry().get(location);
        if (model != null) {
            e.getModelRegistry().put(location, new ChickenBakedItemModel(model));
        }
    }
}

